/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.util.IntInt2ObjHash;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.SasCavity;
import org.jmol.viewer.SasGem;
import org.jmol.viewer.SasNeighborFinder;
import org.jmol.viewer.Sasurface;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class Sasurface1 {
    String surfaceID;
    Graphics3D g3d;
    Viewer viewer;
    short colix;
    Frame frame;
    short mad;
    boolean hide;
    private int GEODESIC_CALC_LEVEL = Sasurface.MAX_GEODESIC_RENDERING_LEVEL;
    int MAX_FULL_TORUS_STEP_COUNT = Sasurface.MAX_FULL_TORUS_STEP_COUNT;
    int OUTER_TORUS_STEP_COUNT = Sasurface.OUTER_TORUS_STEP_COUNT;
    float TARGET_INNER_TORUS_STEP_ANGLE = (float)(Math.PI * 2 / (double)(this.MAX_FULL_TORUS_STEP_COUNT - 1));
    int geodesicRenderingLevel = this.GEODESIC_CALC_LEVEL;
    int surfaceConvexMax;
    int[][] convexVertexMaps;
    int[][] convexFaceMaps;
    short[] colixesConvex;
    int geodesicVertexCount;
    int cavityCount;
    SasCavity[] cavities;
    int torusCount;
    Torus[] toruses;
    private IntInt2ObjHash htToruses;
    final SasGem gem;
    private final SasNeighborFinder neighborFinder;
    final Point3f pointT = new Point3f();
    final Point3f zeroPointT = new Point3f();
    final Point3f centerPointT = new Point3f();
    private static final float PI = (float)Math.PI;
    final Vector3f torusCavityAngleVectorT = new Vector3f();
    final Matrix3f matrixT = new Matrix3f();
    final AxisAngle4f aaT = new AxisAngle4f();
    static final Vector3f vectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f vectorY = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f vectorZ = new Vector3f(0.0f, 0.0f, 1.0f);
    final Vector3f unitRadialVectorT = new Vector3f();
    final Vector3f radialVector90T = new Vector3f();
    final Vector3f vectorT = new Vector3f();
    final Vector3f[] outerRadials = new Vector3f[this.OUTER_TORUS_STEP_COUNT];
    float radiusP;
    float diameterP;
    Point3f[] convexEdgePoints;
    short[] edgeVertexes;

    Sasurface1(String surfaceID, Viewer viewer, Graphics3D g3d, short colix, BitSet bs) {
        int i = this.outerRadials.length;
        while (--i >= 0) {
            this.outerRadials[i] = new Vector3f();
        }
        this.surfaceID = surfaceID;
        this.viewer = viewer;
        this.g3d = g3d;
        this.colix = colix;
        this.frame = viewer.getFrame();
        this.gem = new SasGem(viewer, g3d, this.frame, this.GEODESIC_CALC_LEVEL);
        this.neighborFinder = new SasNeighborFinder(this.frame, this, g3d);
        this.geodesicVertexCount = g3d.getGeodesicVertexCount(this.GEODESIC_CALC_LEVEL);
        this.generate(bs);
    }

    void clearAll() {
        this.surfaceConvexMax = 0;
        this.convexVertexMaps = null;
        this.convexFaceMaps = null;
        this.torusCount = 0;
        this.toruses = null;
        this.cavityCount = 0;
        this.cavities = null;
        this.htToruses = null;
        this.radiusP = this.viewer.getCurrentSolventProbeRadius();
        this.diameterP = 2.0f * this.radiusP;
        this.neighborFinder.setProbeRadius(this.radiusP);
    }

    void generate(BitSet bsSelected) {
        Torus torus;
        int i;
        this.viewer.setSolventOn(true);
        this.clearAll();
        int atomCount = this.frame.atomCount;
        this.convexVertexMaps = new int[atomCount][];
        this.convexFaceMaps = new int[atomCount][];
        this.colixesConvex = new short[atomCount];
        this.htToruses = new IntInt2ObjHash();
        long timeBegin = System.currentTimeMillis();
        int surfaceAtomCount = 0;
        for (i = 0; i < atomCount; ++i) {
            if (!bsSelected.get(i)) continue;
            ++surfaceAtomCount;
            this.neighborFinder.findAbuttingNeighbors(i, bsSelected);
        }
        i = this.torusCount;
        while (--i >= 0) {
            torus = this.toruses[i];
            torus.checkCavityCorrectness0();
            torus.checkCavityCorrectness1();
            torus.electReferenceCavity();
            torus.calcVectors();
            torus.calcCavityAnglesAndSort();
            torus.checkCavityCorrectness2();
            torus.buildTorusSegments();
            torus.calcPointCounts();
            torus.calcNormixes();
            torus.clipVertexMaps();
        }
        i = this.torusCount;
        while (--i >= 0) {
            torus = this.toruses[i];
            torus.stitchWithGeodesics();
        }
        i = atomCount;
        while (--i >= 0) {
            int[] vertexMap = this.convexVertexMaps[i];
            if (vertexMap == null) continue;
            this.convexFaceMaps[i] = this.gem.calcFaceBitmap(vertexMap);
            this.convexVertexMaps[i] = this.gem.calcFaceVertexBitmap(this.convexFaceMaps[i]);
        }
        long timeElapsed = System.currentTimeMillis() - timeBegin;
        System.out.println("surface atom count=" + surfaceAtomCount);
        System.out.println("Surface construction time = " + timeElapsed + " ms");
        this.htToruses = null;
        int i2 = atomCount;
        while (--i2 >= 0 && this.convexVertexMaps[i2] == null) {
        }
        this.surfaceConvexMax = i2 + 1;
    }

    void setSize(int size, BitSet bsSelected) {
        System.out.println("Who is calling me?");
        throw new NullPointerException();
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            System.out.println("I am surfaceID:" + this.surfaceID + " Surface.setProperty(color," + value + ")");
            this.setProperty("colorConvex", value, bs);
            this.setProperty("colorConcave", value, bs);
            this.setProperty("colorSaddle", value, bs);
        }
        if ("translucency" == propertyName) {
            this.setProperty("translucencyConvex", value, bs);
            this.setProperty("translucencyConcave", value, bs);
            this.setProperty("translucencySaddle", value, bs);
        }
        if ("colorConvex" == propertyName) {
            short colix = Graphics3D.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.colixesConvex[i] = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[i], (String)value);
            }
            return;
        }
        if ("translucencyConvex" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.colixesConvex[i] = Graphics3D.setTranslucent(this.colixesConvex[i], isTranslucent);
            }
            return;
        }
        if ("colorSaddle" == propertyName) {
            short colix = Graphics3D.getColix(value);
            int i = this.torusCount;
            while (--i >= 0) {
                Torus torus = this.toruses[i];
                if (bs.get(torus.ixA)) {
                    short s = torus.colixA = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[torus.ixA], (String)value);
                }
                if (!bs.get(torus.ixB)) continue;
                torus.colixB = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[torus.ixB], (String)value);
            }
            return;
        }
        if ("translucencySaddle" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int i = this.torusCount;
            while (--i >= 0) {
                Torus torus = this.toruses[i];
                if (bs.get(torus.ixA)) {
                    torus.colixA = Graphics3D.setTranslucent(torus.colixA, isTranslucent);
                }
                if (!bs.get(torus.ixB)) continue;
                torus.colixB = Graphics3D.setTranslucent(torus.colixB, isTranslucent);
            }
            return;
        }
        if ("colorConcave" == propertyName) {
            return;
        }
        if ("translucencyConcave" == propertyName) {
            return;
        }
        if ("off" == propertyName) {
            this.hide = true;
            return;
        }
        if ("on" == propertyName) {
            this.hide = false;
            return;
        }
    }

    void calcVectors0and90(Point3f planeCenter, Vector3f axisVector, Point3f planeZeroPoint, Vector3f vector0, Vector3f vector90) {
        vector0.sub(planeZeroPoint, planeCenter);
        this.aaT.set(axisVector, 1.5707964f);
        this.matrixT.set(this.aaT);
        this.matrixT.transform(vector0, vector90);
    }

    void calcClippingPlaneCenter(Point3f axisPoint, Vector3f axisUnitVector, Point3f planePoint, Point3f planeCenterPoint) {
        this.vectorT.sub(axisPoint, planePoint);
        float distance = axisUnitVector.dot(this.vectorT);
        planeCenterPoint.scaleAdd(-distance, axisUnitVector, axisPoint);
    }

    void allocateConvexVertexBitmap(int atomIndex) {
        if (this.convexVertexMaps[atomIndex] == null) {
            this.convexVertexMaps[atomIndex] = Bmp.allocateSetAllBits(this.geodesicVertexCount);
        }
    }

    Torus createTorus(int indexI, int indexJ, Point3f torusCenterIJ, float torusRadius, boolean fullTorus) {
        if (torusRadius < this.radiusP) {
            return null;
        }
        if (indexI >= indexJ) {
            throw new NullPointerException();
        }
        if (this.htToruses.get(indexI, indexJ) != null) {
            throw new NullPointerException();
        }
        this.allocateConvexVertexBitmap(indexI);
        this.allocateConvexVertexBitmap(indexJ);
        Torus torus = new Torus(indexI, indexJ, torusCenterIJ, torusRadius, fullTorus);
        this.htToruses.put(indexI, indexJ, torus);
        this.saveTorus(torus);
        return torus;
    }

    void saveTorus(Torus torus) {
        if (this.toruses == null) {
            this.toruses = new Torus[128];
        } else if (this.torusCount == this.toruses.length) {
            this.toruses = (Torus[])Util.doubleLength(this.toruses);
        }
        this.toruses[this.torusCount++] = torus;
    }

    Torus getTorus(int atomIndexA, int atomIndexB) {
        if (atomIndexA >= atomIndexB) {
            throw new NullPointerException();
        }
        return (Torus)this.htToruses.get(atomIndexA, atomIndexB);
    }

    float calcTorusRadius(float radiusA, float radiusB, float distanceAB2) {
        float t1 = radiusA + radiusB + this.diameterP;
        float t2 = t1 * t1 - distanceAB2;
        float diff = radiusA - radiusB;
        float t3 = distanceAB2 - diff * diff;
        if (t2 <= 0.0f || t3 <= 0.0f || distanceAB2 == 0.0f) {
            System.out.println("calcTorusRadius\n radiusA=" + radiusA + " radiusB=" + radiusB + " distanceAB2=" + distanceAB2);
            System.out.println("distanceAB=" + Math.sqrt(distanceAB2) + " t1=" + t1 + " t2=" + t2 + " diff=" + diff + " t3=" + t3);
            throw new NullPointerException();
        }
        return (float)(0.5 * Math.sqrt(t2) * Math.sqrt(t3) / Math.sqrt(distanceAB2));
    }

    void addCavity(int indexI, int indexJ, int indexK, SasCavity cavity) {
        if (this.cavities == null) {
            this.cavities = new SasCavity[32];
        } else if (this.cavityCount == this.cavities.length) {
            this.cavities = (SasCavity[])Util.doubleLength(this.cavities);
        }
        this.cavities[this.cavityCount++] = cavity;
        this.allocateConvexVertexBitmap(indexI);
        this.allocateConvexVertexBitmap(indexJ);
        this.allocateConvexVertexBitmap(indexK);
    }

    class TorusCavity {
        final SasCavity cavity;
        final boolean rightHanded;
        float angle = 0.0f;
        short geodesicVertexA = (short)-1;
        short geodesicVertexB = (short)-1;

        TorusCavity(SasCavity cavity, boolean rightHanded) {
            this.cavity = cavity;
            this.rightHanded = rightHanded;
        }

        void dumpStuff() {
            System.out.println(" geodesicVertexA=" + this.geodesicVertexA + " geodesicVertexB=" + this.geodesicVertexB);
        }

        void calcAngle(Point3f center, Vector3f radialVector, Vector3f radialVector90) {
            Sasurface1.this.torusCavityAngleVectorT.sub(this.cavity.probeCenter, center);
            this.angle = Sasurface1.this.torusCavityAngleVectorT.angle(radialVector);
            float angleCavity90 = Sasurface1.this.torusCavityAngleVectorT.angle(radialVector90);
            if (angleCavity90 <= 1.5707964f) {
                return;
            }
            this.angle = (float)Math.PI * 2 - this.angle;
        }
    }

    class Torus {
        final int ixA;
        final int ixB;
        final Point3f center;
        final float radius;
        final Vector3f radialVector = new Vector3f();
        final Vector3f axisUnitVector = new Vector3f();
        final Vector3f tangentVector = new Vector3f();
        final Vector3f outerRadial = new Vector3f();
        float outerAngle;
        short colixA;
        short colixB;
        byte outerPointCount;
        byte segmentStripCount;
        short totalPointCount;
        short[] normixes;
        short[] connectAConvex;
        short[] seamA;
        short[] seamB;
        final boolean fullTorus;
        short torusCavityCount;
        TorusCavity[] torusCavities;
        int torusSegmentCount;
        TorusSegment[] torusSegments;

        Torus(int indexA, int indexB, Point3f center, float radius, boolean fullTorus) {
            this.ixA = indexA;
            this.ixB = indexB;
            this.center = new Point3f(center);
            this.radius = radius;
            this.fullTorus = fullTorus;
        }

        void dumpTorusSegmentStuff() {
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                this.torusSegments[i].dumpStuff();
            }
        }

        void electReferenceCavity() {
            if (this.fullTorus) {
                return;
            }
            if (this.torusCavities[0].rightHanded) {
                return;
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                TorusCavity torusCavity = this.torusCavities[i];
                if (!torusCavity.rightHanded) continue;
                this.torusCavities[i] = this.torusCavities[0];
                this.torusCavities[0] = torusCavity;
                break;
            }
            if (!this.torusCavities[0].rightHanded) {
                throw new NullPointerException();
            }
        }

        void calcVectors() {
            Point3f centerA = Sasurface1.this.frame.atoms[this.ixA].point3f;
            Point3f centerB = Sasurface1.this.frame.atoms[this.ixB].point3f;
            this.axisUnitVector.sub(centerB, centerA);
            this.axisUnitVector.normalize();
            Point3f referenceProbePoint = null;
            if (this.torusCavities != null) {
                referenceProbePoint = this.torusCavities[0].cavity.probeCenter;
            } else {
                if (this.axisUnitVector.x == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set(vectorX);
                } else if (this.axisUnitVector.y == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set(vectorY);
                } else if (this.axisUnitVector.z == 0.0f) {
                    Sasurface1.this.unitRadialVectorT.set(vectorZ);
                } else {
                    Sasurface1.this.unitRadialVectorT.set(-this.axisUnitVector.y, this.axisUnitVector.x, 0.0f);
                    Sasurface1.this.unitRadialVectorT.normalize();
                }
                referenceProbePoint = Sasurface1.this.pointT;
                Sasurface1.this.pointT.scaleAdd(this.radius, Sasurface1.this.unitRadialVectorT, this.center);
            }
            Sasurface1.this.calcVectors0and90(this.center, this.axisUnitVector, referenceProbePoint, this.radialVector, Sasurface1.this.radialVector90T);
            this.tangentVector.cross(this.axisUnitVector, this.radialVector);
            this.tangentVector.normalize();
            this.outerRadial.sub(centerA, referenceProbePoint);
            this.outerRadial.normalize();
            this.outerRadial.scale(Sasurface1.this.radiusP);
            Sasurface1.this.vectorT.sub(centerB, referenceProbePoint);
            this.outerAngle = this.outerRadial.angle(Sasurface1.this.vectorT);
        }

        void calcPointCounts() {
            int c = (int)((double)((float)Sasurface1.this.OUTER_TORUS_STEP_COUNT * this.outerAngle) / Math.PI);
            if ((c = c + 1 & 0xFE) > Sasurface1.this.OUTER_TORUS_STEP_COUNT) {
                c = Sasurface1.this.OUTER_TORUS_STEP_COUNT;
            } else if (c == 0) {
                c = 2;
            }
            int t = 0;
            int i = this.torusSegmentCount;
            while (--i >= 0) {
                t += this.torusSegments[i].stepCount;
            }
            this.segmentStripCount = (byte)t;
            this.outerPointCount = (byte)c;
            this.totalPointCount = (short)(t * c);
            if (this.totalPointCount == 0) {
                System.out.println("?Que? why is this a torus?");
                System.out.println("calcPointCounts:  outerAngle=" + this.outerAngle + " segmentStripCount=" + this.segmentStripCount + " outerPointCount=" + this.outerPointCount + " totalPointCount=" + this.totalPointCount);
                for (i = 0; i < this.torusSegmentCount; ++i) {
                    TorusSegment ts = this.torusSegments[i];
                    System.out.println("  torusSegment[" + i + "] : " + " .startAngle=" + ts.startAngle + " .stepAngle=" + ts.stepAngle + " .stepCount=" + ts.stepCount);
                }
                throw new NullPointerException();
            }
        }

        void transformOuterRadials() {
            float stepAngle1 = this.outerPointCount <= 1 ? 0.0f : this.outerAngle / (float)(this.outerPointCount - 1);
            Sasurface1.this.aaT.set(this.tangentVector, stepAngle1 * (float)this.outerPointCount);
            int i = this.outerPointCount;
            while (--i > 0) {
                Sasurface1.this.aaT.angle -= stepAngle1;
                Sasurface1.this.matrixT.set(Sasurface1.this.aaT);
                Sasurface1.this.matrixT.transform(this.outerRadial, Sasurface1.this.outerRadials[i]);
            }
            Sasurface1.this.outerRadials[0].set(this.outerRadial);
        }

        void addCavity(SasCavity cavity, boolean rightHanded) {
            if (this.fullTorus) {
                throw new NullPointerException();
            }
            if (this.torusCavities == null) {
                this.torusCavities = new TorusCavity[2];
            } else if (this.torusCavityCount == this.torusCavities.length) {
                this.torusCavities = (TorusCavity[])Util.doubleLength(this.torusCavities);
            }
            this.torusCavities[this.torusCavityCount] = new TorusCavity(cavity, rightHanded);
            this.torusCavityCount = (short)(this.torusCavityCount + 1);
        }

        void checkCavityCorrectness0() {
            if (this.fullTorus ^ this.torusCavityCount == 0) {
                throw new NullPointerException();
            }
        }

        void checkCavityCorrectness1() {
            if ((this.torusCavityCount & 1) != 0) {
                throw new NullPointerException();
            }
            int rightCount = 0;
            int i = this.torusCavityCount;
            while (--i >= 0) {
                if (!this.torusCavities[i].rightHanded) continue;
                ++rightCount;
            }
            if (rightCount != this.torusCavityCount / 2) {
                throw new NullPointerException();
            }
        }

        void calcCavityAnglesAndSort() {
            if (this.fullTorus) {
                return;
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                this.torusCavities[i].calcAngle(this.center, this.radialVector, Sasurface1.this.radialVector90T);
            }
            this.sortTorusCavitiesByAngle();
        }

        void sortTorusCavitiesByAngle() {
            int i = this.torusCavityCount;
            while (--i >= 2) {
                TorusCavity champion = this.torusCavities[i];
                int j = i;
                while (--j > 0) {
                    TorusCavity challenger = this.torusCavities[j];
                    if (!(challenger.angle > champion.angle)) continue;
                    this.torusCavities[j] = champion;
                    this.torusCavities[i] = champion = challenger;
                }
            }
        }

        void checkCavityCorrectness2() {
            if (this.fullTorus) {
                return;
            }
            if ((this.torusCavityCount & 1) != 0) {
                throw new NullPointerException();
            }
            if (this.torusCavities[0].angle != 0.0f) {
                throw new NullPointerException();
            }
            int i = this.torusCavityCount;
            while (--i > 0) {
                if (this.torusCavities[i].angle <= this.torusCavities[i - 1].angle && i != this.torusCavityCount - 1) {
                    throw new NullPointerException();
                }
                if (!((i & 1) == 0 ^ this.torusCavities[i].rightHanded)) continue;
                throw new NullPointerException();
            }
        }

        void buildTorusSegments() {
            if (this.torusCavityCount == 0) {
                this.addTorusSegment(new TorusSegment());
            } else {
                for (int i = 0; i < this.torusCavityCount; i += 2) {
                    this.addTorusSegment(new TorusSegment(this.torusCavities[i], this.torusCavities[i + 1]));
                }
            }
        }

        void addTorusSegment(TorusSegment torusSegment) {
            if (this.torusSegments == null) {
                this.torusSegments = new TorusSegment[4];
            }
            if (this.torusSegmentCount == this.torusSegments.length) {
                this.torusSegments = (TorusSegment[])Util.doubleLength(this.torusSegments);
            }
            this.torusSegments[this.torusSegmentCount++] = torusSegment;
        }

        void calcNormixes() {
            this.transformOuterRadials();
            this.normixes = new short[this.totalPointCount];
            short[] normixes = this.normixes;
            int ix = 0;
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                ix = this.torusSegments[i].calcNormixes(normixes, ix);
            }
        }

        void calcPoints(Point3f[] points) {
            int indexStart = 0;
            this.transformOuterRadials();
            for (int i = 0; i < this.torusSegmentCount; ++i) {
                indexStart = this.torusSegments[i].calcPoints(points, indexStart);
            }
        }

        void calcScreens(Point3f[] points, Point3i[] screens) {
            int i = this.totalPointCount;
            while (--i >= 0) {
                Sasurface1.this.viewer.transformPoint(points[i], screens[i]);
            }
        }

        int getTorusAndGeodesicIndexes(SasCavity cavity, boolean isEdgeA) {
            int i = this.torusCavityCount;
            while (--i >= 0) {
                if (this.torusCavities[i].cavity != cavity) continue;
                return this.torusSegments[i / 2].getTorusAndGeodesicIndexes((i & 1) == 0, isEdgeA);
            }
            throw new NullPointerException();
        }

        void clipVertexMaps() {
            this.clipVertexMap(true);
            this.clipVertexMap(false);
        }

        void clipVertexMap(boolean isEdgeA) {
            int ix = isEdgeA ? this.ixA : this.ixB;
            Atom atom = Sasurface1.this.frame.atoms[ix];
            this.calcZeroPoint(isEdgeA, Sasurface1.this.zeroPointT);
            Sasurface1.this.gem.clipGeodesic(isEdgeA, atom.point3f, atom.getVanderwaalsRadiusFloat(), Sasurface1.this.zeroPointT, this.axisUnitVector, Sasurface1.this.convexVertexMaps[ix]);
        }

        void calcZeroPoint(boolean edgeA, Point3f zeroPoint) {
            Vector3f t;
            if (edgeA) {
                t = this.outerRadial;
            } else {
                Sasurface1.this.aaT.set(this.tangentVector, this.outerAngle);
                Sasurface1.this.matrixT.set(Sasurface1.this.aaT);
                Sasurface1.this.matrixT.transform(this.outerRadial, Sasurface1.this.vectorT);
                t = Sasurface1.this.vectorT;
            }
            zeroPoint.add(this.center, this.radialVector);
            zeroPoint.add(t);
        }

        void calcZeroAndCenterPoints(boolean edgeA, Point3f atomCenter, Point3f zeroPoint, Point3f centerPoint) {
            this.calcZeroPoint(edgeA, zeroPoint);
            Sasurface1.this.calcClippingPlaneCenter(atomCenter, this.axisUnitVector, zeroPoint, centerPoint);
        }

        void calcClippingPlaneCenterPoints(Point3f centerPointA, Point3f centerPointB) {
            this.calcZeroPoint(true, Sasurface1.this.zeroPointT);
            Point3f centerA = Sasurface1.this.frame.atoms[this.ixA].point3f;
            Sasurface1.this.calcClippingPlaneCenter(centerA, this.axisUnitVector, Sasurface1.this.zeroPointT, centerPointA);
            this.calcZeroPoint(false, Sasurface1.this.zeroPointT);
            Point3f centerB = Sasurface1.this.frame.atoms[this.ixB].point3f;
            Sasurface1.this.calcClippingPlaneCenter(centerB, this.axisUnitVector, Sasurface1.this.zeroPointT, centerPointB);
        }

        void stitchWithGeodesics() {
            this.stitchWithGeodesic(true);
            this.stitchWithGeodesic(false);
        }

        void stitchWithGeodesic(boolean isEdgeA) {
            int ix = isEdgeA ? this.ixA : this.ixB;
            Atom atom = Sasurface1.this.frame.atoms[ix];
            float atomRadius = atom.getVanderwaalsRadiusFloat();
            Point3f atomCenter = atom.point3f;
            Sasurface1.this.gem.reset();
            this.calcZeroAndCenterPoints(isEdgeA, atomCenter, Sasurface1.this.zeroPointT, Sasurface1.this.centerPointT);
            boolean dump = false;
            if (Sasurface1.this.gem.projectAndSortGeodesicPoints(isEdgeA, atomCenter, atomRadius, Sasurface1.this.centerPointT, this.axisUnitVector, Sasurface1.this.zeroPointT, this.fullTorus, Sasurface1.this.convexVertexMaps[ix], dump)) {
                this.stitchSegmentsWithSortedProjectedVertexes(isEdgeA);
            }
        }

        void stitchSegmentsWithSortedProjectedVertexes(boolean isEdgeA) {
            boolean dump = false;
            int i = this.torusSegmentCount;
            while (--i >= 0) {
                this.torusSegments[i].stitchWithSortedProjectedVertexes(isEdgeA, dump);
            }
            short[] seam = Sasurface1.this.gem.createSeam();
            if (isEdgeA) {
                this.seamA = seam;
            } else {
                this.seamB = seam;
            }
        }

        class TorusSegment {
            final TorusCavity startCavity;
            final TorusCavity endCavity;
            float startAngle;
            float stepAngle;
            int stepCount;

            TorusSegment() {
                this.endCavity = null;
                this.startCavity = null;
                this.startAngle = 0.0f;
                this.stepAngle = ((Torus)Torus.this).Sasurface1.this.TARGET_INNER_TORUS_STEP_ANGLE;
                this.stepCount = ((Torus)Torus.this).Sasurface1.this.MAX_FULL_TORUS_STEP_COUNT;
            }

            TorusSegment(TorusCavity startCavity, TorusCavity endCavity) {
                this.startCavity = startCavity;
                this.endCavity = endCavity;
                this.startAngle = startCavity.angle;
                float totalSegmentAngle = endCavity.angle - this.startAngle;
                if (totalSegmentAngle < 0.0f) {
                    totalSegmentAngle += (float)Math.PI * 2;
                }
                this.stepCount = (int)(totalSegmentAngle / ((Torus)Torus.this).Sasurface1.this.TARGET_INNER_TORUS_STEP_ANGLE);
                this.stepAngle = totalSegmentAngle / (float)this.stepCount;
                ++this.stepCount;
            }

            void dumpStuff() {
                System.out.print(" start ixA=" + Torus.this.ixA + " ixB=" + Torus.this.ixB);
                this.startCavity.dumpStuff();
                System.out.print("   end ixA=" + Torus.this.ixA + " ixB=" + Torus.this.ixB);
                this.endCavity.dumpStuff();
            }

            int calcPoints(Point3f[] points, int ixPoint) {
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisUnitVector, this.startAngle);
                int i = this.stepCount;
                while (--i >= 0) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform(Torus.this.radialVector, ((Torus)Torus.this).Sasurface1.this.pointT);
                    ((Torus)Torus.this).Sasurface1.this.pointT.add(Torus.this.center);
                    int j = 0;
                    while (j < Torus.this.outerPointCount) {
                        ((Torus)Torus.this).Sasurface1.this.matrixT.transform(((Torus)Torus.this).Sasurface1.this.outerRadials[j], ((Torus)Torus.this).Sasurface1.this.vectorT);
                        points[ixPoint].add(((Torus)Torus.this).Sasurface1.this.pointT, ((Torus)Torus.this).Sasurface1.this.vectorT);
                        ++j;
                        ++ixPoint;
                    }
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
                return ixPoint;
            }

            int calcNormixes(short[] normixes, int ix) {
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisUnitVector, this.startAngle);
                int i = this.stepCount;
                while (--i >= 0) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    int j = 0;
                    while (j < Torus.this.outerPointCount) {
                        ((Torus)Torus.this).Sasurface1.this.matrixT.transform(((Torus)Torus.this).Sasurface1.this.outerRadials[j], ((Torus)Torus.this).Sasurface1.this.vectorT);
                        normixes[ix] = ((Torus)Torus.this).Sasurface1.this.g3d.get2SidedNormix(((Torus)Torus.this).Sasurface1.this.vectorT);
                        ++j;
                        ++ix;
                    }
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
                return ix;
            }

            void calcEdgePoints(Point3f[] edgePoints, boolean edgeA) {
                int outerRadialIndex;
                if (edgeA) {
                    Torus.this.transformOuterRadials();
                    outerRadialIndex = 0;
                } else {
                    outerRadialIndex = Torus.this.outerPointCount - 1;
                }
                ((Torus)Torus.this).Sasurface1.this.aaT.set(Torus.this.axisUnitVector, this.startAngle);
                for (int i = 0; i < this.stepCount; ++i) {
                    ((Torus)Torus.this).Sasurface1.this.matrixT.set(((Torus)Torus.this).Sasurface1.this.aaT);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform(Torus.this.radialVector, ((Torus)Torus.this).Sasurface1.this.pointT);
                    ((Torus)Torus.this).Sasurface1.this.pointT.add(Torus.this.center);
                    ((Torus)Torus.this).Sasurface1.this.matrixT.transform(((Torus)Torus.this).Sasurface1.this.outerRadials[outerRadialIndex], ((Torus)Torus.this).Sasurface1.this.vectorT);
                    edgePoints[i].add(((Torus)Torus.this).Sasurface1.this.pointT, ((Torus)Torus.this).Sasurface1.this.vectorT);
                    ((Torus)Torus.this).Sasurface1.this.aaT.angle += this.stepAngle;
                }
            }

            void stitchWithSortedProjectedVertexes(boolean isEdgeA, boolean dump) {
                if (dump) {
                    System.out.println("stitchWithSortedProjectedVertexes(isEdgeA " + isEdgeA + ")");
                    System.out.println("startCavity.angle=" + this.startCavity.angle + " endCavity.angle=" + this.endCavity.angle);
                    System.out.println("startAngle=" + this.startAngle + " stepAngle=" + this.stepAngle + " stepCount=" + this.stepCount);
                    System.out.println("totalArc=" + this.stepAngle * (float)this.stepCount);
                    System.out.println("totalArc2=" + this.stepAngle * (float)(this.stepCount - 1));
                }
                ((Torus)Torus.this).Sasurface1.this.gem.stitchWithTorusSegment(this.getSegmentStartingVertex(isEdgeA), Torus.this.outerPointCount, this.startAngle, this.stepAngle, this.stepCount, dump);
                if (this.startCavity != null) {
                    if (isEdgeA) {
                        this.startCavity.geodesicVertexA = ((Torus)Torus.this).Sasurface1.this.gem.firstStitchedGeodesicVertex;
                        this.endCavity.geodesicVertexA = ((Torus)Torus.this).Sasurface1.this.gem.lastStitchedGeodesicVertex;
                    } else {
                        this.startCavity.geodesicVertexB = ((Torus)Torus.this).Sasurface1.this.gem.firstStitchedGeodesicVertex;
                        this.endCavity.geodesicVertexB = ((Torus)Torus.this).Sasurface1.this.gem.lastStitchedGeodesicVertex;
                    }
                }
            }

            short getSegmentStartingVertex(boolean isEdgeA) {
                int totalStepCount = 0;
                for (int i = 0; i < Torus.this.torusSegmentCount; ++i) {
                    TorusSegment segment = Torus.this.torusSegments[i];
                    if (segment == this) {
                        int startingVertex = totalStepCount * Torus.this.outerPointCount;
                        if (!isEdgeA) {
                            startingVertex += Torus.this.outerPointCount - 1;
                        }
                        return (short)startingVertex;
                    }
                    totalStepCount += segment.stepCount;
                }
                System.out.println("torus segment not found in torus");
                throw new NullPointerException();
            }

            int getTorusAndGeodesicIndexes(boolean isBeginning, boolean isEdgeA) {
                short torusVertex = this.getSegmentStartingVertex(isEdgeA);
                if (!isBeginning) {
                    torusVertex = (short)(torusVertex + (this.stepCount - 1) * Torus.this.outerPointCount);
                }
                int geodesicVertex = 0;
                return torusVertex << 16 | geodesicVertex;
            }
        }
    }
}

