/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Viewer;

class ModelManager {
    final Viewer viewer;
    final JmolAdapter adapter;
    String fullPathName;
    String fileName;
    String modelSetName;
    boolean haveFile = false;
    Frame frame;
    private final Point3f pointT = new Point3f();
    boolean autoBond = true;
    float bondTolerance = 0.45f;
    float minBondDistance = 0.4f;
    float solventProbeRadius = 1.2f;
    boolean solventOn = false;
    int[] shapeSizes = new int[27];
    Hashtable[] shapeProperties = new Hashtable[27];
    private static final Object NULL_SURROGATE = new Object();

    ModelManager(Viewer viewer, JmolAdapter adapter) {
        this.viewer = viewer;
        this.adapter = adapter;
    }

    void setClientFile(String fullPathName, String fileName, Object clientFile) {
        if (clientFile == null) {
            this.modelSetName = null;
            fileName = null;
            fullPathName = null;
            this.frame = null;
            this.haveFile = false;
        } else {
            this.fullPathName = fullPathName;
            this.fileName = fileName;
            this.modelSetName = this.adapter.getAtomSetCollectionName(clientFile);
            if (this.modelSetName != null) {
                this.modelSetName = this.modelSetName.trim();
                if (this.modelSetName.length() == 0) {
                    this.modelSetName = null;
                }
            }
            if (this.modelSetName == null) {
                this.modelSetName = this.reduceFilename(fileName);
            }
            this.frame = new Frame(this.viewer, this.adapter, clientFile);
            this.haveFile = true;
        }
    }

    String reduceFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        int ichDot = fileName.indexOf(46);
        if (ichDot > 0) {
            fileName = fileName.substring(0, ichDot);
        }
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 20) + " ...";
        }
        return fileName;
    }

    String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return this.adapter.getClientAtomStringProperty(clientAtom, propertyName);
    }

    Frame getFrame() {
        return this.frame;
    }

    JmolAdapter getExportJmolAdapter() {
        return this.frame == null ? null : this.frame.getExportJmolAdapter();
    }

    String getModelSetName() {
        return this.modelSetName;
    }

    String getModelSetFileName() {
        return this.fileName;
    }

    String getModelSetPathName() {
        return this.fullPathName;
    }

    Properties getModelSetProperties() {
        return this.frame == null ? null : this.frame.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.frame == null ? null : this.frame.getModelSetProperty(propertyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.frame == null ? false : this.frame.modelSetHasVibrationVectors();
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        return this.frame == null ? false : this.frame.modelHasVibrationVectors(modelIndex);
    }

    String getModelSetTypeName() {
        return this.frame == null ? null : this.frame.getModelSetTypeName();
    }

    int getModelCount() {
        return this.frame == null ? 0 : this.frame.getModelCount();
    }

    String getModelName(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelName(modelIndex);
    }

    int getModelNumber(int modelIndex) {
        return this.frame == null ? -1 : this.frame.getModelNumber(modelIndex);
    }

    Properties getModelProperties(int modelIndex) {
        return this.frame == null ? null : this.frame.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.frame == null ? null : this.frame.getModelProperty(modelIndex, propertyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.frame == null ? -1 : this.frame.getModelNumberIndex(modelNumber);
    }

    boolean hasVibrationVectors() {
        return this.frame.hasVibrationVectors();
    }

    float getRotationRadius() {
        return this.frame == null ? 1.0f : this.frame.getRotationRadius();
    }

    void increaseRotationRadius(float increaseInAngstroms) {
        if (this.frame != null) {
            this.frame.increaseRotationRadius(increaseInAngstroms);
        }
    }

    Point3f getBoundBoxCenter() {
        return this.frame == null ? null : this.frame.getBoundBoxCenter();
    }

    Vector3f getBoundBoxCornerVector() {
        return this.frame == null ? null : this.frame.getBoundBoxCornerVector();
    }

    int getChainCount() {
        return this.frame == null ? 0 : this.frame.getChainCount();
    }

    int getGroupCount() {
        return this.frame == null ? 0 : this.frame.getGroupCount();
    }

    int getPolymerCount() {
        return this.frame == null ? 0 : this.frame.getPolymerCount();
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.frame == null ? 0 : this.frame.getPolymerCountInModel(modelIndex);
    }

    int getAtomCount() {
        return this.frame == null ? 0 : this.frame.getAtomCount();
    }

    int getBondCount() {
        return this.frame == null ? 0 : this.frame.getBondCount();
    }

    void setCenterBitSet(BitSet bsCenter) {
        if (this.frame == null) {
            return;
        }
        Point3f center = null;
        if (bsCenter != null) {
            int countSelected = 0;
            center = this.pointT;
            center.set(0.0f, 0.0f, 0.0f);
            int i = this.getAtomCount();
            while (--i >= 0) {
                if (!bsCenter.get(i)) continue;
                ++countSelected;
                center.add(this.frame.getAtomPoint3f(i));
            }
            if (countSelected > 0) {
                center.scale(1.0f / (float)countSelected);
            } else {
                center = null;
            }
        }
        if (!this.viewer.isWindowCentered()) {
            if (center == null) {
                center = this.frame.getRotationCenterDefault();
            }
            Point3i newCenterScreen = this.viewer.transformPoint(center);
            this.viewer.translateCenterTo(newCenterScreen.x, newCenterScreen.y);
        }
        this.frame.setRotationCenter(center);
    }

    void setRotationCenter(Point3f center) {
        if (this.frame != null) {
            this.frame.setRotationCenter(center);
        }
    }

    Point3f getRotationCenter() {
        return this.frame == null ? null : this.frame.getRotationCenter();
    }

    Point3f getDefaultRotationCenter() {
        return this.frame == null ? null : this.frame.getDefaultRotationCenter();
    }

    void setRotationCenter(String relativeTo, float x, float y, float z) {
        if (this.frame == null) {
            return;
        }
        this.pointT.set(x, y, z);
        if (relativeTo == "average") {
            this.pointT.add(this.frame.getAverageAtomPoint());
        } else if (relativeTo == "boundbox") {
            this.pointT.add(this.frame.getBoundBoxCenter());
        } else if (relativeTo != "absolute") {
            this.pointT.set(this.frame.getRotationCenterDefault());
        }
        this.frame.setRotationCenter(this.pointT);
    }

    void setAutoBond(boolean ab) {
        this.autoBond = ab;
    }

    void setBondTolerance(float bondTolerance) {
        this.bondTolerance = bondTolerance;
    }

    void setMinBondDistance(float minBondDistance) {
        this.minBondDistance = minBondDistance;
    }

    boolean frankClicked(int x, int y) {
        return this.getShapeSize(19) != 0 && this.frame.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        return this.frame == null ? -1 : this.frame.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubber) {
        return this.frame.findAtomsInRectangle(rectRubber);
    }

    void setSolventProbeRadius(float radius) {
        this.solventProbeRadius = radius;
    }

    void setSolventOn(boolean solventOn) {
        this.solventOn = solventOn;
    }

    void loadShape(int shapeID) {
        if (this.frame != null) {
            this.frame.loadShape(shapeID);
        }
    }

    void setShapeSize(int shapeType, int size, BitSet bsSelected) {
        this.shapeSizes[shapeType] = size;
        if (this.frame != null) {
            this.frame.setShapeSize(shapeType, size, bsSelected);
        }
    }

    int getShapeSize(int shapeType) {
        return this.shapeSizes[shapeType];
    }

    void setShapeProperty(int shapeType, String propertyName, Object value, BitSet bsSelected) {
        Hashtable<String, Object> props = this.shapeProperties[shapeType];
        if (props == null) {
            props = this.shapeProperties[shapeType] = new Hashtable<String, Object>();
        }
        propertyName = propertyName.intern();
        props.put(propertyName, value != null ? value : NULL_SURROGATE);
        if (this.frame != null) {
            this.frame.setShapeProperty(shapeType, propertyName, value, bsSelected);
        }
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        Hashtable props;
        Object value = null;
        if (this.frame != null) {
            value = this.frame.getShapeProperty(shapeType, propertyName, index);
        }
        if (value == null && (props = this.shapeProperties[shapeType]) != null && (value = props.get(propertyName)) == NULL_SURROGATE) {
            value = null;
            return null;
        }
        return value;
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.frame == null ? -1 : this.frame.getAtomIndexFromAtomNumber(atomNumber);
    }

    BitSet getElementsPresentBitSet() {
        return this.frame == null ? null : this.frame.getElementsPresentBitSet();
    }

    BitSet getGroupsPresentBitSet() {
        return this.frame == null ? null : this.frame.getGroupsPresentBitSet();
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        if (this.frame != null) {
            this.frame.calcSelectedGroupsCount(bsSelected);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        if (this.frame != null) {
            this.frame.calcSelectedMonomersCount(bsSelected);
        }
    }

    String getAtomInfo(int i) {
        return this.frame.getAtomAt(i).getInfo();
    }

    String getElementSymbol(int i) {
        return this.frame.getAtomAt(i).getElementSymbol();
    }

    int getElementNumber(int i) {
        return this.frame.getAtomAt(i).getElementNumber();
    }

    String getAtomName(int i) {
        return this.frame.getAtomAt(i).getAtomName();
    }

    int getAtomNumber(int i) {
        return this.frame.getAtomAt(i).getAtomNumber();
    }

    float getAtomX(int i) {
        return this.frame.getAtomAt(i).getAtomX();
    }

    float getAtomY(int i) {
        return this.frame.getAtomAt(i).getAtomY();
    }

    float getAtomZ(int i) {
        return this.frame.getAtomAt(i).getAtomZ();
    }

    Point3f getAtomPoint3f(int i) {
        return this.frame.getAtomAt(i).getPoint3f();
    }

    float getAtomRadius(int i) {
        return this.frame.getAtomAt(i).getRadius();
    }

    short getAtomColix(int i) {
        return this.frame.getAtomAt(i).getColix();
    }

    String getAtomChain(int i) {
        return "" + this.frame.getAtomAt(i).getChainID();
    }

    String getAtomSequenceCode(int i) {
        return this.frame.getAtomAt(i).getSeqcodeString();
    }

    int getAtomModelIndex(int i) {
        return this.frame.getAtomAt(i).getModelIndex();
    }

    Point3f getBondPoint3f1(int i) {
        return this.frame.getBondAt(i).getAtom1().getPoint3f();
    }

    Point3f getBondPoint3f2(int i) {
        return this.frame.getBondAt(i).getAtom2().getPoint3f();
    }

    float getBondRadius(int i) {
        return this.frame.getBondAt(i).getRadius();
    }

    short getBondOrder(int i) {
        return this.frame.getBondAt(i).getOrder();
    }

    short getBondColix1(int i) {
        return this.frame.getBondAt(i).getColix1();
    }

    short getBondColix2(int i) {
        return this.frame.getBondAt(i).getColix2();
    }

    int getBondModelIndex(int i) {
        Atom atom = this.frame.getBondAt(i).getAtom1();
        if (atom != null) {
            return atom.getModelIndex();
        }
        atom = this.frame.getBondAt(i).getAtom2();
        if (atom != null) {
            return atom.getModelIndex();
        }
        return 0;
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        Polymer polymer = this.frame.getPolymerAt(modelIndex, polymerIndex);
        return polymer.getLeadMidpoints();
    }
}

